/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.block;

import com.google.common.collect.ImmutableMap;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightBlocks;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightMobEffect;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.Tilt;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SpikeTrapBlock
extends HorizontalDirectionalBlock
implements BonemealableBlock,
SimpleWaterloggedBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final EnumProperty<Tilt> TILT = BlockStateProperties.f_155996_;
    private static final int NO_TICK = -1;
    private static final Object2IntMap<Tilt> DELAY_UNTIL_NEXT_TILT_STATE = (Object2IntMap)Util.m_137469_((Object)new Object2IntArrayMap(), p_152305_ -> {
        p_152305_.defaultReturnValue(-1);
        p_152305_.put((Object)Tilt.UNSTABLE, 10);
        p_152305_.put((Object)Tilt.PARTIAL, 10);
        p_152305_.put((Object)Tilt.FULL, 100);
    });
    private static final int MAX_GEN_HEIGHT = 5;
    private static final int STEM_WIDTH = 6;
    private float entity_damage = 1.0f;
    private boolean isLongType = false;
    private static final int LOWEST_LEAF_TOP = 13;
    protected static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    protected static final VoxelShape EAST_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    protected static final VoxelShape WEST_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final Map<Tilt, VoxelShape> LEAF_SHAPES = ImmutableMap.of((Object)Tilt.NONE, (Object)Block.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), (Object)Tilt.UNSTABLE, (Object)Block.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), (Object)Tilt.PARTIAL, (Object)Block.m_49796_((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), (Object)Tilt.FULL, (Object)Block.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0));
    private static final VoxelShape STEM_SLICER = Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<Direction, VoxelShape> STEM_SHAPES = ImmutableMap.of((Object)Direction.NORTH, (Object)Shapes.m_83148_((VoxelShape)NORTH_SHAPE, (VoxelShape)STEM_SLICER, (BooleanOp)BooleanOp.f_82685_), (Object)Direction.SOUTH, (Object)Shapes.m_83148_((VoxelShape)SOUTH_SHAPE, (VoxelShape)STEM_SLICER, (BooleanOp)BooleanOp.f_82685_), (Object)Direction.EAST, (Object)Shapes.m_83148_((VoxelShape)EAST_SHAPE, (VoxelShape)STEM_SLICER, (BooleanOp)BooleanOp.f_82685_), (Object)Direction.WEST, (Object)Shapes.m_83148_((VoxelShape)WEST_SHAPE, (VoxelShape)STEM_SLICER, (BooleanOp)BooleanOp.f_82685_));
    private final Map<BlockState, VoxelShape> shapesCache;

    public SpikeTrapBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(TILT, (Comparable)Tilt.NONE));
        this.shapesCache = this.m_152458_(SpikeTrapBlock::calculateShape);
    }

    public SpikeTrapBlock(Float damage, BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(TILT, (Comparable)Tilt.NONE));
        this.shapesCache = this.m_152458_(SpikeTrapBlock::calculateShape);
        this.entity_damage = damage.floatValue();
    }

    public SpikeTrapBlock(boolean isLong, Float damage, BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_(TILT, (Comparable)Tilt.NONE));
        this.shapesCache = this.m_152458_(SpikeTrapBlock::calculateShape);
        this.entity_damage = damage.floatValue();
        this.isLongType = isLong;
    }

    private static VoxelShape calculateShape(BlockState p_152318_) {
        return Shapes.m_83110_((VoxelShape)LEAF_SHAPES.get(p_152318_.m_61143_(TILT)), (VoxelShape)STEM_SHAPES.get(p_152318_.m_61143_((Property)f_54117_)));
    }

    public static void placeWithRandomHeight(LevelAccessor pLevel, RandomSource pRandom, BlockPos pPos, Direction pDirection) {
        int j;
        int i = Mth.m_216271_((RandomSource)pRandom, (int)2, (int)5);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.m_122032_();
        for (j = 0; j < i && SpikeTrapBlock.canPlaceAt((LevelHeightAccessor)pLevel, (BlockPos)blockpos$mutableblockpos, pLevel.m_8055_((BlockPos)blockpos$mutableblockpos)); ++j) {
            blockpos$mutableblockpos.m_122173_(Direction.UP);
        }
        int k = pPos.m_123342_() + j - 1;
        blockpos$mutableblockpos.m_142448_(pPos.m_123342_());
        while (blockpos$mutableblockpos.m_123342_() < k) {
            SpikeTrapBlock.place(pLevel, (BlockPos)blockpos$mutableblockpos, pLevel.m_6425_((BlockPos)blockpos$mutableblockpos), pDirection);
            blockpos$mutableblockpos.m_122173_(Direction.UP);
        }
        SpikeTrapBlock.place(pLevel, (BlockPos)blockpos$mutableblockpos, pLevel.m_6425_((BlockPos)blockpos$mutableblockpos), pDirection);
    }

    private static boolean canReplace(BlockState pState) {
        return pState.m_60795_() || pState.m_60713_(Blocks.f_49990_) || pState.m_60713_(Blocks.f_152547_);
    }

    protected static boolean canPlaceAt(LevelHeightAccessor pLevel, BlockPos pPos, BlockState pState) {
        return !pLevel.m_151570_(pPos) && SpikeTrapBlock.canReplace(pState);
    }

    protected static boolean place(LevelAccessor pLevel, BlockPos pPos, FluidState pFluidState, Direction pDirection) {
        BlockState blockstate = (BlockState)((BlockState)Blocks.f_152545_.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(pFluidState.m_164512_((Fluid)Fluids.f_76193_)))).m_61124_((Property)f_54117_, (Comparable)pDirection);
        return pLevel.m_7731_(pPos, blockstate, 3);
    }

    public void m_5581_(Level pLevel, BlockState pState, BlockHitResult pHit, Projectile pProjectile) {
        this.setTiltAndScheduleTick(pState, pLevel, pHit.m_82425_(), Tilt.FULL, SoundEvents.f_12312_);
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.m_7495_();
        BlockState blockstate = pLevel.m_8055_(blockpos);
        return true;
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        boolean isGround;
        if (pDirection == Direction.DOWN && !pState.m_60710_((LevelReader)pLevel, pPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        boolean bl = isGround = pDirection == Direction.UP && SpikeTrapBlock.m_49918_((VoxelShape)pNeighborState.m_60812_((BlockGetter)pLevel, pPos.m_7494_()), (Direction)Direction.DOWN);
        if (isGround) {
            Double rare = this.isLongType ? 3.0 : 1.0;
            List list = pLevel.m_45976_(LivingEntity.class, new AABB(pPos.m_7494_()).m_82377_(rare.doubleValue(), rare.doubleValue(), rare.doubleValue()));
            if (!list.isEmpty()) {
                for (LivingEntity livingentity : list) {
                    if (!(livingentity instanceof Player) && !(livingentity.m_21223_() > this.entity_damage)) continue;
                    livingentity.m_6469_(livingentity.m_9236_().m_269111_().m_269325_(), this.entity_damage);
                }
            }
        }
        return isGround ? (BlockState)this.m_152465_(pState).m_61124_(TILT, (Comparable)Tilt.FULL) : super.m_7417_(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        BlockState blockstate = pLevel.m_8055_(pPos.m_7494_());
        return false;
    }

    public boolean m_214167_(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return false;
    }

    public void m_214148_(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (!pLevel.f_46443_) {
            if (pState.m_61143_(TILT) == Tilt.NONE && SpikeTrapBlock.canEntityTilt(pPos, pEntity) && !pLevel.m_276867_(pPos)) {
                this.setTiltAndScheduleTick(pState, pLevel, pPos, Tilt.UNSTABLE, null);
            }
            if (pEntity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)pEntity;
                if (pState.m_61143_(TILT) == Tilt.FULL && (livingentity instanceof Player || livingentity.m_21223_() > this.entity_damage)) {
                    livingentity.m_6469_(pLevel.m_269111_().m_269325_(), this.entity_damage);
                }
            }
        }
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pLevel.m_276867_(pPos)) {
            SpikeTrapBlock.resetTilt(pState, (Level)pLevel, pPos);
        } else {
            Tilt tilt = (Tilt)pState.m_61143_(TILT);
            if (tilt == Tilt.UNSTABLE) {
                this.setTiltAndScheduleTick(pState, (Level)pLevel, pPos, Tilt.PARTIAL, SoundEvents.f_243893_);
            } else if (tilt == Tilt.PARTIAL) {
                Double rare = this.isLongType ? 3.0 : 1.0;
                List list = pLevel.m_45976_(LivingEntity.class, new AABB(pPos.m_7494_()).m_82377_(rare.doubleValue(), rare.doubleValue(), rare.doubleValue()));
                if (!list.isEmpty()) {
                    for (LivingEntity livingentity : list) {
                        if (!(livingentity instanceof Player) && !(livingentity.m_21223_() > this.entity_damage)) continue;
                        livingentity.m_6469_(pLevel.m_269111_().m_269325_(), this.entity_damage);
                    }
                }
                this.setTiltAndScheduleTick(pState, (Level)pLevel, pPos, Tilt.FULL, SoundEvents.f_12312_);
            } else if (tilt == Tilt.FULL) {
                SpikeTrapBlock.resetTilt(pState, (Level)pLevel, pPos);
            }
        }
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean pMovedByPiston) {
        if (pLevel.m_276867_(pPos)) {
            SpikeTrapBlock.resetTilt(pState, pLevel, pPos);
        }
    }

    private static void playTiltSound(Level pLevel, BlockPos pPos, SoundEvent pSound) {
        float f = Mth.m_216283_((RandomSource)pLevel.f_46441_, (float)0.8f, (float)1.2f);
        pLevel.m_5594_((Player)null, pPos, pSound, SoundSource.BLOCKS, 1.0f, f);
    }

    private static boolean canEntityTilt(BlockPos pPos, Entity pEntity) {
        return pEntity.m_20096_() && pEntity.m_20182_().f_82480_ > (double)((float)pPos.m_123342_() + 0.6875f);
    }

    private void setTiltAndScheduleTick(BlockState pState, Level pLevel, BlockPos pPos, Tilt pTilt, @Nullable SoundEvent pSound) {
        SpikeTrapBlock.setTilt(pState, pLevel, pPos, pTilt);
        if (pSound != null) {
            SpikeTrapBlock.playTiltSound(pLevel, pPos, pSound);
        }
        int i = DELAY_UNTIL_NEXT_TILT_STATE.getInt((Object)pTilt);
        if (this.isLongType) {
            i = (int)((double)i * 1.5);
        }
        if (i != -1) {
            pLevel.m_186460_(pPos, (Block)this, i);
        }
    }

    private static void resetTilt(BlockState pState, Level pLevel, BlockPos pPos) {
        SpikeTrapBlock.setTilt(pState, pLevel, pPos, Tilt.NONE);
        if (pState.m_61143_(TILT) != Tilt.NONE) {
            SpikeTrapBlock.playTiltSound(pLevel, pPos, SoundEvents.f_12311_);
        }
    }

    private static void setTilt(BlockState pState, Level pLevel, BlockPos pPos, Tilt pTilt) {
        Tilt tilt = (Tilt)pState.m_61143_(TILT);
        pLevel.m_7731_(pPos, (BlockState)pState.m_61124_(TILT, (Comparable)pTilt), 2);
        if (pTilt.m_156084_() && pTilt != tilt) {
            pLevel.m_142346_((Entity)null, GameEvent.f_157792_, pPos);
        }
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return LEAF_SHAPES.get(pState.m_61143_(TILT));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapesCache.get(pState);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState blockstate = pContext.m_43725_().m_8055_(pContext.m_8083_().m_7495_());
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        boolean flag = blockstate.m_60713_(Blocks.f_152545_) || blockstate.m_60713_(Blocks.f_152546_);
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_164512_((Fluid)Fluids.f_76193_)))).m_61124_((Property)f_54117_, (Comparable)(flag ? (Direction)blockstate.m_61143_((Property)f_54117_) : pContext.m_8125_().m_122424_()));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{WATERLOGGED, f_54117_, TILT});
    }

    public void m_141947_(Level pLevel, BlockPos pPos, BlockState pState, Entity entity) {
        super.m_141947_(pLevel, pPos, pState, entity);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (pState.m_60713_((Block)ImmortalersDelightBlocks.LONG_SPIKE_TRAP.get())) {
                this.onLongSpikeTrap(pState, living);
                return;
            }
            if (pState.m_60713_((Block)ImmortalersDelightBlocks.POISONOUS_LONG_SPIKE_TRAP.get())) {
                this.onPoisonousLongSpikeTrap(pState, living);
                return;
            }
            if (pState.m_60713_((Block)ImmortalersDelightBlocks.POISONOUS_METAL_CALTROP.get())) {
                this.onPoisonousMetalCaltrop(pState, living);
                return;
            }
            if (pState.m_60713_((Block)ImmortalersDelightBlocks.POISONOUS_SPIKE_TRAP.get())) {
                this.onPoisonousSpikeTrap(pState, living);
                return;
            }
        }
    }

    private void onLongSpikeTrap(BlockState state, LivingEntity entity) {
        if (state.m_61143_((Property)BlockStateProperties.f_155996_) == Tilt.FULL && (entity instanceof Player ? !((Player)entity).m_7500_() : entity.m_21223_() > 4.0f)) {
            entity.m_6469_(entity.m_269291_().m_269325_(), 4.0f);
        }
    }

    private void onPoisonousLongSpikeTrap(BlockState state, LivingEntity entity) {
        if (state.m_61143_((Property)BlockStateProperties.f_155996_) == Tilt.FULL && (entity instanceof Player ? !((Player)entity).m_7500_() : entity.m_21223_() > 2.0f)) {
            entity.m_6469_(entity.m_269291_().m_269325_(), 2.0f);
            if (!entity.m_21023_((MobEffect)ImmortalersDelightMobEffect.WEAK_POISON.get()) && !entity.m_21023_(MobEffects.f_19614_)) {
                entity.m_7292_(new MobEffectInstance((MobEffect)ImmortalersDelightMobEffect.WEAK_POISON.get(), 100, 4));
            }
        }
    }

    private void onPoisonousMetalCaltrop(BlockState state, LivingEntity entity) {
        if (entity instanceof Player ? !((Player)entity).m_7500_() : entity.m_21223_() > 2.0f) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 30, 3));
        }
    }

    private void onPoisonousSpikeTrap(BlockState state, LivingEntity entity) {
        if (state.m_61143_((Property)BlockStateProperties.f_155996_) == Tilt.FULL && (entity instanceof Player ? !((Player)entity).m_7500_() : entity.m_21223_() > 2.0f) && !entity.m_21023_((MobEffect)ImmortalersDelightMobEffect.WEAK_POISON.get()) && !entity.m_21023_(MobEffects.f_19614_)) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 80, 1));
        }
    }
}

